<?php
/**
 * Laravel版: web.php
 * routes/web.php
 * 
 * Laravelの利点：
 * - URLとファイル構造の分離
 * - RESTful設計の簡単な実装
 * - 名前付きルートによる柔軟性
 * - ミドルウェアの適用が簡単
 */

use App\Http\Controllers\PostController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| 掲示板システムのルート定義
| 生PHPと異なり、URLは自由に設計可能
|
*/

// 投稿一覧表示（GET）
Route::get('/', [PostController::class, 'index'])
    ->name('posts.index');

// 新規投稿処理（POST）
// 自動的にCSRF保護が適用される
Route::post('/posts', [PostController::class, 'store'])
    ->name('posts.store');

// もし認証が必要な場合は、ミドルウェアを簡単に適用できる
// Route::middleware(['auth'])->group(function () {
//     Route::post('/posts', [PostController::class, 'store'])
//         ->name('posts.store');
// });

// RESTfulな完全なリソースルートも1行で定義可能
// Route::resource('posts', PostController::class);