<?php
/**
 * 投稿処理ページ
 * 
 * 問題点：
 * - CSRF対策が実装されていない
 * - バリデーション処理が不十分
 * - エラーハンドリングが複雑
 * - 直接アクセスへの対策が不完全
 */

// データベース接続を読み込み
require_once 'config.php';

// POSTデータが送信されているかチェック
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

// 入力データを取得
$name = $_POST['name'] ?? '';
$message = $_POST['message'] ?? '';

// 簡単なバリデーション
$errors = [];

if (empty($name)) {
    $errors[] = '名前を入力してください。';
} elseif (mb_strlen($name) > 50) {
    $errors[] = '名前は50文字以内で入力してください。';
}

if (empty($message)) {
    $errors[] = 'メッセージを入力してください。';
} elseif (mb_strlen($message) > 1000) {
    $errors[] = 'メッセージは1000文字以内で入力してください。';
}

// エラーがある場合は元のページにリダイレクト
if (!empty($errors)) {
    session_start();
    $_SESSION['errors'] = $errors;
    $_SESSION['old_input'] = ['name' => $name, 'message' => $message];
    header('Location: index.php');
    exit;
}

try {
    // データベースに投稿を保存
    $sql = "INSERT INTO posts (name, message) VALUES (:name, :message)";
    $stmt = $pdo->prepare($sql);
    
    // SQLインジェクション対策：プリペアドステートメントを使用
    $stmt->bindParam(':name', $name, PDO::PARAM_STR);
    $stmt->bindParam(':message', $message, PDO::PARAM_STR);
    
    $stmt->execute();
    
    // 成功メッセージを設定（本来はセッションで管理すべき）
    session_start();
    $_SESSION['success'] = '投稿が完了しました。';
    
} catch (PDOException $e) {
    // エラー処理（本番環境では詳細なエラーを表示すべきではない）
    session_start();
    $_SESSION['errors'] = ['投稿の保存に失敗しました。'];
    header('Location: index.php');
    exit;
}

// 投稿一覧ページにリダイレクト
header('Location: index.php');
exit;