# 第2章 サンプルコード - Laravel開発環境の構築

このディレクトリには、第2章で解説する開発環境構築に必要な設定ファイルのサンプルが含まれています。

## ファイル構成

```
chapter02/
├── composer.json           # Laravelプロジェクトの依存関係定義
├── .env.example           # 環境変数設定のサンプル
├── docker-compose.yml     # Laravel Sail用Docker設定
├── php.ini               # PHP設定ファイルのサンプル
└── artisan-commands.md   # よく使うArtisanコマンド集
```

## 環境構築の手順

### 1. XAMPP/MAMPを使った環境構築

1. XAMPP/MAMPをダウンロードしてインストール
2. ApacheとMySQLを起動
3. PHPバージョンを確認：`php -v`
4. Composerをインストール

### 2. Composerを使ったLaravelインストール

```bash
# Laravel 12をインストール（2025年2月以降）
composer create-project laravel/laravel my-app "^12.0"

# プロジェクトディレクトリに移動
cd my-app

# 開発サーバーを起動
php artisan serve
```

### 3. Laravel Sailを使った環境構築

```bash
# Sailを使って新規プロジェクトを作成
curl -s "https://laravel.build/my-app" | bash

# プロジェクトディレクトリに移動
cd my-app

# Sailコンテナを起動
./vendor/bin/sail up -d

# Sailコンテナを停止
./vendor/bin/sail down
```

## 環境変数の設定

`.env`ファイルは、環境に応じた設定を管理するための重要なファイルです。

### 開発環境の例

```
APP_ENV=local
APP_DEBUG=true
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
```

### 本番環境の例

```
APP_ENV=production
APP_DEBUG=false
DB_CONNECTION=mysql
DB_HOST=production-db-server
DB_PORT=3306
```

## トラブルシューティング

### PHPエクステンションエラー

必要な拡張モジュールを確認：

```bash
php -m | grep -E "(openssl|pdo|mbstring|tokenizer|xml|ctype|json|bcmath|fileinfo)"
```

### Composer関連のエラー

キャッシュをクリア：

```bash
composer clear-cache
composer update
```

### パーミッションエラー

storage と bootstrap/cache ディレクトリの権限を設定：

```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

## 推奨される開発ツール

1. **VS Code** - 軽量で高機能なエディタ
   - Laravel Extension Pack
   - PHP Intelephense
   - Laravel Blade Snippets

2. **PhpStorm** - 高機能なPHP IDE
   - Laravel Plugin
   - Laravel Idea Plugin

3. **TablePlus/DBeaver** - データベース管理ツール

## 次のステップ

環境構築が完了したら、第3章「ルーティングとMVCの基礎」に進んで、実際のアプリケーション開発を始めましょう。