# Artisanコマンド集

Laravel開発でよく使うArtisanコマンドの一覧です。

## 基本コマンド

### プロジェクト管理

```bash
# Laravelのバージョン確認
php artisan --version

# 利用可能なコマンド一覧を表示
php artisan list

# 特定のコマンドのヘルプを表示
php artisan help [コマンド名]

# アプリケーションキーを生成
php artisan key:generate

# 設定キャッシュをクリア
php artisan config:clear

# 設定をキャッシュ（本番環境向け）
php artisan config:cache

# ルートキャッシュをクリア
php artisan route:clear

# ルートをキャッシュ（本番環境向け）
php artisan route:cache
```

### 開発サーバー

```bash
# 開発サーバーを起動（デフォルト: http://127.0.0.1:8000）
php artisan serve

# ポートを指定して起動
php artisan serve --port=8080

# ホストを指定して起動
php artisan serve --host=0.0.0.0
```

## データベース関連

### マイグレーション

```bash
# マイグレーションを実行
php artisan migrate

# マイグレーションをロールバック（最後のバッチ）
php artisan migrate:rollback

# すべてのマイグレーションをロールバック
php artisan migrate:reset

# ロールバック後、再度マイグレーションを実行
php artisan migrate:refresh

# データベースを削除して再作成後、マイグレーションを実行
php artisan migrate:fresh

# マイグレーションの状態を確認
php artisan migrate:status

# マイグレーションファイルを作成
php artisan make:migration create_users_table

# テーブル作成用マイグレーション
php artisan make:migration create_posts_table --create=posts

# テーブル変更用マイグレーション
php artisan make:migration add_email_to_users_table --table=users
```

### シーダー

```bash
# シーダーを実行
php artisan db:seed

# 特定のシーダーを実行
php artisan db:seed --class=UserSeeder

# マイグレーションとシーダーを同時に実行
php artisan migrate --seed

# シーダーファイルを作成
php artisan make:seeder UserSeeder
```

## ファイル生成コマンド

### コントローラー

```bash
# 基本的なコントローラーを作成
php artisan make:controller UserController

# リソースコントローラーを作成（CRUD用）
php artisan make:controller PostController --resource

# APIコントローラーを作成
php artisan make:controller ApiController --api

# モデルと一緒に作成
php artisan make:controller TaskController --resource --model=Task
```

### モデル

```bash
# モデルを作成
php artisan make:model User

# マイグレーションと一緒に作成
php artisan make:model Post -m

# ファクトリーと一緒に作成
php artisan make:model Product -f

# コントローラー、マイグレーション、ファクトリーをすべて作成
php artisan make:model Task -mfc
```

### その他のファイル

```bash
# リクエストクラスを作成
php artisan make:request StoreUserRequest

# ミドルウェアを作成
php artisan make:middleware CheckAge

# ポリシーを作成
php artisan make:policy PostPolicy --model=Post

# リソースを作成（API用）
php artisan make:resource UserResource

# コマンドを作成
php artisan make:command SendEmails

# イベントを作成
php artisan make:event UserRegistered

# リスナーを作成
php artisan make:listener SendWelcomeEmail

# ジョブを作成
php artisan make:job ProcessPayment

# メールを作成
php artisan make:mail WelcomeMail

# 通知を作成
php artisan make:notification InvoicePaid

# ルールを作成（バリデーション用）
php artisan make:rule Uppercase

# テストを作成
php artisan make:test UserTest
php artisan make:test UserTest --unit
```

## キャッシュ管理

```bash
# アプリケーションキャッシュをクリア
php artisan cache:clear

# ビューキャッシュをクリア
php artisan view:clear

# ルートキャッシュをクリア
php artisan route:clear

# 設定キャッシュをクリア
php artisan config:clear

# イベントキャッシュをクリア
php artisan event:clear

# すべてのキャッシュをクリア
php artisan optimize:clear

# アプリケーションを最適化（本番環境向け）
php artisan optimize
```

## デバッグとメンテナンス

```bash
# ルート一覧を表示
php artisan route:list

# 特定のパスのルートを検索
php artisan route:list --path=api

# Tinker（対話型シェル）を起動
php artisan tinker

# メンテナンスモードを有効化
php artisan down

# メンテナンスモード中の秘密トークンを設定
php artisan down --secret="1630542a-246b-4b66-afa1-dd72a4c43515"

# メンテナンスモードを解除
php artisan up

# ストレージリンクを作成
php artisan storage:link

# キューワーカーを起動
php artisan queue:work

# スケジューラーを実行
php artisan schedule:run
```

## Laravel Sail コマンド（Docker環境）

```bash
# Sailコンテナを起動
./vendor/bin/sail up

# バックグラウンドで起動
./vendor/bin/sail up -d

# Sailコンテナを停止
./vendor/bin/sail down

# Sailでartisanコマンドを実行
./vendor/bin/sail artisan migrate

# Sailでcomposerコマンドを実行
./vendor/bin/sail composer update

# Sailでnpmコマンドを実行
./vendor/bin/sail npm install

# MySQLコンソールに接続
./vendor/bin/sail mysql
```

## テスト関連

```bash
# すべてのテストを実行
php artisan test

# 特定のテストクラスを実行
php artisan test --filter UserTest

# コードカバレッジ付きでテスト実行
php artisan test --coverage

# 並列実行
php artisan test --parallel
```

## Tips

1. **エイリアスの設定**（`.bashrc`や`.zshrc`に追加）

```bash
alias pa="php artisan"
alias sail="./vendor/bin/sail"
```

2. **よく使うコマンドの組み合わせ**

```bash
# 開発環境をリセット
php artisan migrate:fresh --seed

# キャッシュを完全にクリア
php artisan optimize:clear

# 本番デプロイ前の最適化
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

3. **デバッグ時に便利なコマンド**

```bash
# 設定値を確認
php artisan tinker
>>> config('app.name')
>>> env('APP_ENV')

# モデルのデータを確認
>>> User::all()
>>> Post::find(1)
```