{{-- 
    resources/views/layouts/app.blade.php
    
    メインレイアウトテンプレート
    全ページで共通のHTML構造を定義
--}}

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    {{-- ページタイトル --}}
    <title>@yield('title', 'Laravel Shop') - {{ config('app.name') }}</title>
    
    {{-- SEOメタタグ --}}
    <meta name="description" content="@yield('description', 'Laravel実践入門のサンプルECサイト')">
    <meta name="keywords" content="@yield('keywords', 'Laravel, ECサイト, サンプル')">
    
    {{-- OGPタグ --}}
    <meta property="og:title" content="@yield('og_title', '@yield('title', 'Laravel Shop')')">
    <meta property="og:description" content="@yield('og_description', '@yield('description')')">
    <meta property="og:image" content="@yield('og_image', asset('images/og-default.jpg'))">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:type" content="@yield('og_type', 'website')">
    
    {{-- Favicon --}}
    <link rel="icon" href="{{ asset('favicon.ico') }}">
    
    {{-- CSS --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    
    {{-- ページ固有のCSS --}}
    @stack('styles')
</head>
<body>
    {{-- ヘッダー --}}
    <header class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}">
                {{ config('app.name') }}
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('home')) active @endif" href="{{ route('home') }}">
                            ホーム
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('products.*')) active @endif" href="{{ route('products.index') }}">
                            商品一覧
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('about')) active @endif" href="{{ route('about') }}">
                            About
                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    @guest
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">ログイン</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">新規登録</a>
                        </li>
                    @else
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                                {{ Auth::user()->name }}
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{ route('profile') }}">プロフィール</a></li>
                                <li><a class="dropdown-item" href="{{ route('orders') }}">注文履歴</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="dropdown-item">ログアウト</button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    @endguest
                </ul>
            </div>
        </div>
    </header>
    
    {{-- フラッシュメッセージ --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show m-0" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show m-0" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if(session('warning'))
        <div class="alert alert-warning alert-dismissible fade show m-0" role="alert">
            {{ session('warning') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if(session('info'))
        <div class="alert alert-info alert-dismissible fade show m-0" role="alert">
            {{ session('info') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    {{-- パンくずリスト --}}
    @hasSection('breadcrumb')
        <nav aria-label="breadcrumb">
            <div class="container">
                <ol class="breadcrumb py-2 mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">ホーム</a></li>
                    @yield('breadcrumb')
                </ol>
            </div>
        </nav>
    @endif
    
    {{-- メインコンテンツ --}}
    <main class="py-4">
        <div class="container">
            @yield('content')
        </div>
    </main>
    
    {{-- フッター --}}
    <footer class="bg-dark text-white py-4 mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <h5>{{ config('app.name') }}</h5>
                    <p>Laravel実践入門のサンプルECサイトです。</p>
                </div>
                <div class="col-md-4">
                    <h5>リンク</h5>
                    <ul class="list-unstyled">
                        <li><a href="{{ route('privacy') }}" class="text-white-50">プライバシーポリシー</a></li>
                        <li><a href="{{ route('terms') }}" class="text-white-50">利用規約</a></li>
                        <li><a href="{{ route('about') }}" class="text-white-50">会社概要</a></li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <h5>お問い合わせ</h5>
                    <p class="text-white-50">
                        Email: info@example.com<br>
                        Tel: 03-1234-5678
                    </p>
                </div>
            </div>
            <hr class="bg-white">
            <div class="text-center">
                <small>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</small>
            </div>
        </div>
    </footer>
    
    {{-- JavaScript --}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    
    {{-- ページ固有のJavaScript --}}
    @stack('scripts')
</body>
</html>