# 第1章 サンプルコード - なぜフレームワークが必要なのか

このディレクトリには、第1章で解説する「生PHPの問題点」と「Laravelによる解決」を示すサンプルコードが含まれています。

## ディレクトリ構成

```
chapter01/
├── raw-php-bulletin/      # 生PHPによる脆弱な掲示板の例
│   ├── config.php         # データベース接続設定
│   ├── index.php          # 投稿一覧・投稿フォーム
│   ├── post.php           # 投稿処理
│   └── style.css          # スタイルシート
└── laravel-bulletin/      # Laravel版の掲示板（簡略版）
    ├── PostController.php # コントローラー
    ├── Post.php          # モデル
    ├── web.php           # ルーティング
    └── migration.php     # マイグレーション
```

## 生PHPの問題点

### 1. セキュリティ脆弱性
- XSS（クロスサイトスクリプティング）攻撃への脆弱性
- CSRF（クロスサイトリクエストフォージェリ）対策の欠如
- SQLインジェクション攻撃のリスク

### 2. コードの重複
- データベース接続処理の重複
- HTML構造の重複
- エラーハンドリングの重複

### 3. 構造の問題
- ビジネスロジックとプレゼンテーション層の混在
- URLとファイル構造の密結合
- テストの困難性

## 使用方法

### 生PHP版の実行

1. データベースを作成します：
```sql
CREATE DATABASE bulletin_db;
USE bulletin_db;
CREATE TABLE posts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(50),
    message TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
```

2. `config.php`のデータベース設定を環境に合わせて修正します

3. Webサーバーのドキュメントルートに配置してアクセスします

### Laravel版の実行

Laravel版は概念を示すための簡略版です。実際の実装は第3章以降で詳しく解説します。

## 学習ポイント

1. **セキュリティの比較**
   - 生PHP：手動でエスケープ処理が必要
   - Laravel：自動的にエスケープ処理

2. **コード構造の比較**
   - 生PHP：処理が1つのファイルに混在
   - Laravel：MVC構造で責任分離

3. **開発効率の比較**
   - 生PHP：すべて手動実装
   - Laravel：豊富な機能を標準装備

## 注意事項

⚠️ **生PHP版のコードは教育目的のため、意図的に脆弱性を含んでいます。本番環境では絶対に使用しないでください。**

実際のWebアプリケーション開発では、必ずLaravelのようなセキュアなフレームワークを使用することを強く推奨します。