{{-- 
    Laravel版: index.blade.php
    resources/views/posts/index.blade.php
    
    Laravelの利点：
    - Bladeテンプレートエンジンによる簡潔な記述
    - 自動的なXSS対策（エスケープ）
    - テンプレート継承機能
    - CSRF保護の自動適用
--}}

@extends('layouts.app')

@section('content')
<div class="container">
    <h1>シンプル掲示板（Laravel版）</h1>
    
    {{-- フラッシュメッセージの表示 --}}
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    
    {{-- バリデーションエラーの表示（自動的にエスケープ） --}}
    @if($errors->any())
        <div class="error-messages">
            @foreach($errors->all() as $error)
                <p class="error">{{ $error }}</p>
            @endforeach
        </div>
    @endif
    
    {{-- 投稿フォーム --}}
    <div class="post-form">
        <h2>新規投稿</h2>
        <form action="{{ route('posts.store') }}" method="POST">
            {{-- CSRF保護トークン（自動的に検証される） --}}
            @csrf
            
            <div class="form-group">
                <label for="name">名前：</label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       value="{{ old('name') }}" 
                       class="@error('name') is-invalid @enderror"
                       required>
                @error('name')
                    <span class="invalid-feedback">{{ $message }}</span>
                @enderror
            </div>
            
            <div class="form-group">
                <label for="message">メッセージ：</label>
                <textarea id="message" 
                          name="message" 
                          rows="5" 
                          class="@error('message') is-invalid @enderror"
                          required>{{ old('message') }}</textarea>
                @error('message')
                    <span class="invalid-feedback">{{ $message }}</span>
                @enderror
            </div>
            
            <button type="submit">投稿する</button>
        </form>
    </div>
    
    {{-- 投稿一覧 --}}
    <div class="posts">
        <h2>投稿一覧</h2>
        
        @forelse($posts as $post)
            <div class="post">
                <div class="post-header">
                    {{-- 自動的にエスケープされる --}}
                    <strong>{{ $post->name }}</strong>
                    <span class="post-date">
                        {{-- Carbonによる日付フォーマット --}}
                        {{ $post->created_at->format('Y/m/d H:i') }}
                    </span>
                </div>
                <div class="post-message">
                    {{-- nl2br相当の処理（エスケープ済み） --}}
                    {!! nl2br(e($post->message)) !!}
                </div>
            </div>
        @empty
            <p>まだ投稿がありません。</p>
        @endforelse
    </div>
</div>
@endsection