<?php
/**
 * Laravel版: マイグレーションファイル
 * database/migrations/2024_01_01_000000_create_posts_table.php
 * 
 * Laravelの利点：
 * - バージョン管理可能なデータベース構造
 * - ロールバック機能
 * - 環境間での一貫性保証
 * - 型安全な定義
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * マイグレーション実行
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            // 主キー（自動的にAUTO_INCREMENT）
            $table->id();
            
            // 投稿者名（VARCHAR(50)）
            $table->string('name', 50);
            
            // メッセージ本文（TEXT）
            $table->text('message');
            
            // タイムスタンプ（created_at, updated_at）
            // Laravelが自動的に管理
            $table->timestamps();
            
            // インデックスの追加も簡単
            $table->index('created_at');
        });
    }
    
    /**
     * マイグレーションのロールバック
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
};