<?php
/**
 * データベース接続設定ファイル
 * 
 * 問題点：
 * - パスワードがハードコーディングされている
 * - 環境別の設定切り替えが困難
 * - バージョン管理システムに機密情報が含まれる
 */

// データベース接続設定
define('DB_HOST', 'localhost');
define('DB_NAME', 'bulletin_db');
define('DB_USER', 'root');
define('DB_PASS', 'password');

try {
    // PDO接続を作成
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    // エラー情報を直接表示（本番環境では危険）
    die("データベース接続エラー: " . $e->getMessage());
}