<?php
/**
 * 投稿一覧・投稿フォーム表示ページ
 * 
 * 問題点：
 * - ビジネスロジックとプレゼンテーション層が混在
 * - HTMLとPHPが混在して可読性が悪い
 * - エラー処理が散在
 * - CSRF対策がない
 */

// データベース接続を読み込み
require_once 'config.php';

// セッション開始（エラー表示用）
session_start();

// 投稿データを取得
$sql = "SELECT name, message, created_at FROM posts ORDER BY created_at DESC";
$stmt = $pdo->query($sql);
$posts = $stmt->fetchAll();

// エラーメッセージを取得して削除
$errors = $_SESSION['errors'] ?? [];
$old_input = $_SESSION['old_input'] ?? [];
unset($_SESSION['errors']);
unset($_SESSION['old_input']);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>シンプル掲示板</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>シンプル掲示板</h1>
        
        <!-- エラー表示 -->
        <?php if (!empty($errors)): ?>
            <div class="error-messages">
                <?php foreach ($errors as $error): ?>
                    <!-- XSS脆弱性：エラーメッセージのエスケープ忘れ -->
                    <p class="error"><?php echo $error; ?></p>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <!-- 投稿フォーム -->
        <div class="post-form">
            <h2>新規投稿</h2>
            <!-- CSRF対策がないフォーム -->
            <form action="post.php" method="POST">
                <div class="form-group">
                    <label for="name">名前：</label>
                    <input type="text" id="name" name="name" 
                           value="<?php echo htmlspecialchars($old_input['name'] ?? ''); ?>" 
                           required>
                </div>
                <div class="form-group">
                    <label for="message">メッセージ：</label>
                    <textarea id="message" name="message" rows="5" required><?php echo htmlspecialchars($old_input['message'] ?? ''); ?></textarea>
                </div>
                <button type="submit">投稿する</button>
            </form>
        </div>
        
        <!-- 投稿一覧 -->
        <div class="posts">
            <h2>投稿一覧</h2>
            <?php if (empty($posts)): ?>
                <p>まだ投稿がありません。</p>
            <?php else: ?>
                <?php foreach ($posts as $post): ?>
                    <div class="post">
                        <div class="post-header">
                            <strong><?php echo htmlspecialchars($post['name']); ?></strong>
                            <span class="post-date">
                                <?php echo date('Y/m/d H:i', strtotime($post['created_at'])); ?>
                            </span>
                        </div>
                        <div class="post-message">
                            <!-- 改行をbrタグに変換（潜在的なXSSリスク） -->
                            <?php echo nl2br(htmlspecialchars($post['message'])); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>