<?php
/**
 * database/migrations/2024_01_01_000001_create_users_table.php
 * 
 * ユーザーテーブルのマイグレーション
 * 基本的なテーブル作成の例
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * マイグレーション実行
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            // 主キー（UNSIGNED BIGINT AUTO_INCREMENT）
            $table->id();
            
            // 基本情報
            $table->string('name');                          // VARCHAR(255)
            $table->string('email')->unique();               // ユニーク制約付き
            $table->timestamp('email_verified_at')->nullable(); // NULL許可
            $table->string('password');
            
            // プロフィール情報
            $table->string('avatar')->nullable();            // アバター画像パス
            $table->text('bio')->nullable();                 // 自己紹介
            $table->date('birth_date')->nullable();          // 生年月日
            $table->enum('gender', ['male', 'female', 'other'])->nullable(); // 性別
            
            // 連絡先情報
            $table->string('phone', 20)->nullable();         // 電話番号
            $table->string('address')->nullable();           // 住所
            $table->string('city', 100)->nullable();         // 市区町村
            $table->string('postal_code', 10)->nullable();   // 郵便番号
            
            // ステータス
            $table->boolean('is_active')->default(true);     // アクティブフラグ
            $table->boolean('is_admin')->default(false);     // 管理者フラグ
            $table->integer('login_count')->default(0);      // ログイン回数
            $table->timestamp('last_login_at')->nullable();  // 最終ログイン日時
            
            // トークン
            $table->string('remember_token', 100)->nullable(); // Remember Meトークン
            
            // タイムスタンプ（created_at, updated_at）
            $table->timestamps();
            
            // ソフトデリート
            $table->softDeletes();                           // deleted_at
            
            // インデックス
            $table->index('email');                          // 検索高速化
            $table->index('is_active');
            $table->index(['created_at', 'is_active']);      // 複合インデックス
        });
    }
    
    /**
     * マイグレーションのロールバック
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};