<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>@yield('title', 'タスク管理システム') - Laravel教育書第5章</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- カスタムCSS -->
    <style>
        :root {
            --primary-color: #3498db;
            --success-color: #2ecc71;
            --warning-color: #f39c12;
            --danger-color: #e74c3c;
            --info-color: #17a2b8;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }

        .navbar-brand {
            font-weight: 700;
            color: var(--primary-color) !important;
        }

        .card {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border: none;
            transition: transform 0.2s ease-in-out;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }

        .badge {
            font-size: 0.75rem;
            padding: 0.375rem 0.5rem;
        }

        .task-priority-1 { background-color: var(--info-color); }
        .task-priority-2 { background-color: var(--success-color); }
        .task-priority-3 { background-color: var(--warning-color); }
        .task-priority-4 { background-color: var(--danger-color); }

        .task-status-pending { color: var(--warning-color); }
        .task-status-in_progress { color: var(--info-color); }
        .task-status-completed { color: var(--success-color); }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .btn-primary:hover {
            background-color: #2980b9;
            border-color: #2980b9;
        }

        .search-box {
            max-width: 400px;
        }

        .sidebar {
            background-color: var(--light-color);
            min-height: calc(100vh - 56px);
        }

        .main-content {
            padding: 2rem 0;
        }

        .footer {
            background-color: var(--dark-color);
            color: white;
            padding: 2rem 0;
            margin-top: auto;
        }

        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .container-fluid {
            flex: 1;
        }

        /* Alpine.js用のアニメーション */
        [x-cloak] {
            display: none !important;
        }

        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* フォーム関連 */
        .form-label {
            font-weight: 600;
            color: var(--dark-color);
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
        }

        /* ページネーション */
        .pagination .page-link {
            color: var(--primary-color);
        }

        .pagination .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        /* レスポンシブデザイン */
        @media (max-width: 768px) {
            .sidebar {
                display: none;
            }
            
            .main-content {
                padding: 1rem 0;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <!-- ナビゲーションバー -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="{{ route('tasks.index') }}">
                <i class="fas fa-tasks me-2"></i>タスク管理システム
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('tasks.index') ? 'active' : '' }}" 
                           href="{{ route('tasks.index') }}">
                            <i class="fas fa-list me-1"></i>タスク一覧
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('tasks.create') ? 'active' : '' }}" 
                           href="{{ route('tasks.create') }}">
                            <i class="fas fa-plus me-1"></i>新規作成
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('tasks.statistics') ? 'active' : '' }}" 
                           href="{{ route('tasks.statistics') }}">
                            <i class="fas fa-chart-bar me-1"></i>統計情報
                        </a>
                    </li>
                </ul>
                
                <!-- 検索フォーム -->
                <div class="d-flex me-3">
                    <form action="{{ route('tasks.index') }}" method="GET" class="d-flex search-box">
                        <input type="text" class="form-control form-control-sm me-2" 
                               name="search" 
                               value="{{ request('search') }}" 
                               placeholder="タスクを検索...">
                        <button type="submit" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-search"></i>
                        </button>
                    </form>
                </div>
                
                <!-- ユーザーメニュー -->
                <ul class="navbar-nav">
                    @auth
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-user me-1"></i>{{ auth()->user()->name }}
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i>設定</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form action="{{ route('logout') }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="dropdown-item">
                                            <i class="fas fa-sign-out-alt me-2"></i>ログアウト
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    @else
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">ログイン</a>
                        </li>
                    @endauth
                </ul>
            </div>
        </div>
    </nav>

    <!-- メインコンテンツ -->
    <div class="container-fluid">
        <div class="row">
            <!-- サイドバー -->
            <div class="col-md-3 col-lg-2 sidebar p-3 d-none d-md-block">
                <h6 class="text-muted mb-3">フィルター</h6>
                
                <!-- クイックフィルター -->
                <div class="mb-4" x-data="{ activeFilter: '{{ request('status', 'all') }}' }">
                    <div class="list-group list-group-flush">
                        <a href="{{ route('tasks.index') }}" 
                           class="list-group-item list-group-item-action border-0 py-2"
                           :class="activeFilter === 'all' ? 'active' : ''">
                            <i class="fas fa-list me-2"></i>すべて
                        </a>
                        <a href="{{ route('tasks.index', ['status' => 'pending']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2"
                           :class="activeFilter === 'pending' ? 'active' : ''">
                            <i class="fas fa-clock me-2 text-warning"></i>未着手
                        </a>
                        <a href="{{ route('tasks.index', ['status' => 'in_progress']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2"
                           :class="activeFilter === 'in_progress' ? 'active' : ''">
                            <i class="fas fa-play me-2 text-info"></i>進行中
                        </a>
                        <a href="{{ route('tasks.index', ['status' => 'completed']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2"
                           :class="activeFilter === 'completed' ? 'active' : ''">
                            <i class="fas fa-check me-2 text-success"></i>完了
                        </a>
                    </div>
                </div>

                <!-- 優先度フィルター -->
                <h6 class="text-muted mb-3">優先度</h6>
                <div class="mb-4">
                    <div class="list-group list-group-flush">
                        <a href="{{ route('tasks.index', ['priority' => '4']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2">
                            <span class="badge task-priority-4 me-2">緊急</span>
                        </a>
                        <a href="{{ route('tasks.index', ['priority' => '3']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2">
                            <span class="badge task-priority-3 me-2">高</span>
                        </a>
                        <a href="{{ route('tasks.index', ['priority' => '2']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2">
                            <span class="badge task-priority-2 me-2">中</span>
                        </a>
                        <a href="{{ route('tasks.index', ['priority' => '1']) }}" 
                           class="list-group-item list-group-item-action border-0 py-2">
                            <span class="badge task-priority-1 me-2">低</span>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- メインコンテンツエリア -->
            <div class="col-md-9 col-lg-10 main-content">
                <!-- フラッシュメッセージ -->
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert" x-data x-init="setTimeout(() => $el.remove(), 5000)">
                        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert" x-data x-init="setTimeout(() => $el.remove(), 5000)">
                        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert" x-data x-init="setTimeout(() => $el.remove(), 5000)">
                        <i class="fas fa-exclamation-triangle me-2"></i>{{ session('warning') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- ページヘッダー -->
                @hasSection('header')
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        @yield('header')
                    </div>
                @endif

                <!-- メインコンテンツ -->
                @yield('content')
            </div>
        </div>
    </div>

    <!-- フッター -->
    <footer class="footer mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h6>Laravel教育書 第5章サンプル</h6>
                    <p class="mb-0 text-muted">実用的なCRUDアプリケーション開発</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0 text-muted">
                        Built with Laravel {{ app()->version() }} & Alpine.js
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- カスタムJavaScript -->
    <script>
        // CSRF トークンをAjaxリクエストで自動設定
        document.addEventListener('DOMContentLoaded', function() {
            const token = document.querySelector('meta[name="csrf-token"]');
            if (token) {
                window.axios = window.axios || {};
                window.axios.defaults = window.axios.defaults || {};
                window.axios.defaults.headers = window.axios.defaults.headers || {};
                window.axios.defaults.headers.common = window.axios.defaults.headers.common || {};
                window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token.getAttribute('content');
            }
        });

        // フォームの二重送信防止
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function(e) {
                const submitButton = form.querySelector('button[type="submit"]');
                if (submitButton) {
                    submitButton.disabled = true;
                    submitButton.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>処理中...';
                }
            });
        });
    </script>
    
    @stack('scripts')
</body>
</html>