# 第8章 サンプルコード - 本番環境へのデプロイ

このディレクトリには、第8章で解説する本番環境デプロイに必要な設定ファイルのサンプルが含まれています。

## ディレクトリ構成

```
chapter08/
├── config/
│   ├── .env.production     # 本番環境用環境変数
│   └── deploy.php          # Deployerの設定
├── deployment/
│   ├── deploy.sh           # デプロイスクリプト
│   └── rollback.sh         # ロールバックスクリプト
└── nginx/
    ├── laravel.conf        # Nginx設定ファイル
    └── ssl.conf            # SSL設定
```

## 環境設定

### 開発環境と本番環境の違い

| 設定項目 | 開発環境 | 本番環境 |
|---------|---------|---------|
| APP_ENV | local | production |
| APP_DEBUG | true | false |
| LOG_LEVEL | debug | error |
| CACHE_DRIVER | file | redis |
| SESSION_DRIVER | file | redis |
| QUEUE_CONNECTION | sync | redis |

## デプロイ手順

### 1. サーバー準備

```bash
# 必要なパッケージのインストール
sudo apt update
sudo apt install nginx php8.2-fpm php8.2-mysql php8.2-mbstring php8.2-xml php8.2-bcmath
sudo apt install redis-server mysql-server
sudo apt install git composer nodejs npm

# ディレクトリの作成
sudo mkdir -p /var/www/laravel
sudo chown -R www-data:www-data /var/www/laravel
```

### 2. アプリケーションのデプロイ

```bash
# コードのクローン
cd /var/www/laravel
git clone https://github.com/your-repo/laravel-app.git .

# 依存パッケージのインストール
composer install --no-dev --optimize-autoloader

# 環境変数の設定
cp .env.production .env
php artisan key:generate

# ストレージリンクの作成
php artisan storage:link

# キャッシュの最適化
php artisan config:cache
php artisan route:cache
php artisan view:cache

# データベースマイグレーション
php artisan migrate --force

# パーミッションの設定
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### 3. Nginxの設定

```bash
# 設定ファイルのコピー
sudo cp nginx/laravel.conf /etc/nginx/sites-available/laravel
sudo ln -s /etc/nginx/sites-available/laravel /etc/nginx/sites-enabled/

# 設定のテスト
sudo nginx -t

# Nginxの再起動
sudo systemctl restart nginx
```

### 4. SSL証明書の設定（Let's Encrypt）

```bash
# Certbotのインストール
sudo apt install certbot python3-certbot-nginx

# SSL証明書の取得
sudo certbot --nginx -d yourdomain.com

# 自動更新の設定
sudo certbot renew --dry-run
```

## パフォーマンス最適化

### OPcacheの設定

```ini
opcache.enable=1
opcache.memory_consumption=256
opcache.max_accelerated_files=20000
opcache.revalidate_freq=0
opcache.validate_timestamps=0
```

### Redisの活用

```bash
# Redisのインストール
sudo apt install redis-server

# Laravelの設定
CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=redis
```

## 監視とログ

### ログローテーションの設定

```bash
# /etc/logrotate.d/laravel
/var/www/laravel/storage/logs/*.log {
    daily
    missingok
    rotate 14
    compress
    delaycompress
    notifempty
    create 0640 www-data www-data
    sharedscripts
}
```

### モニタリング

```bash
# New Relicの導入
curl -L https://download.newrelic.com/548C16BF.gpg | sudo apt-key add -
sudo sh -c 'echo "deb http://apt.newrelic.com/debian/ newrelic non-free" > /etc/apt/sources.list.d/newrelic.list'
sudo apt update
sudo apt install newrelic-php5
```

## CI/CDパイプライン

### GitHub Actionsの例

```yaml
name: Deploy

on:
  push:
    branches: [main]

jobs:
  deploy:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v2
      
      - name: Deploy to server
        uses: appleboy/ssh-action@master
        with:
          host: ${{ secrets.HOST }}
          username: ${{ secrets.USERNAME }}
          key: ${{ secrets.SSH_KEY }}
          script: |
            cd /var/www/laravel
            git pull origin main
            composer install --no-dev
            php artisan migrate --force
            php artisan config:cache
            php artisan route:cache
            php artisan view:cache
```

## トラブルシューティング

### よくある問題と解決策

1. **500 Internal Server Error**
   - ストレージパーミッションを確認
   - .envファイルの存在を確認
   - ログファイルを確認

2. **データベース接続エラー**
   - .envのDB設定を確認
   - MySQLサービスの状態を確認
   - ファイアウォール設定を確認

3. **ページが見つからない**
   - Nginxの設定を確認
   - URLリライトルールを確認
   - public/index.phpの存在を確認

## セキュリティチェックリスト

- [ ] APP_DEBUG=false に設定
- [ ] HTTPSを強制
- [ ] 不要なポートを閉じる
- [ ] ファイアウォールを設定
- [ ] 定期的なバックアップを設定
- [ ] セキュリティアップデートを適用
- [ ] rate limitingを設定
- [ ] CSRFトークンを有効化
- [ ] SQLインジェクション対策を確認
- [ ] XSS対策を確認